<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExchangeMoney extends Model
{
    use SoftDeletes;
    protected $guarded = ['id'];

    protected $table = "exchange_moneys";


    public function user()
    {
        return $this->belongsTo('App\User','user_id');
    }
    public function receive_method()
    {
        return $this->belongsTo('App\Currency','receive_method_id');
    }

    public function send_method()
    {
        return $this->belongsTo('App\Currency','send_method_id');
    }
}
